% Nise, N.S. 
% Control Systems Engineering, 7th ed. 
% John Wiley & Sons, Hoboken, NJ, 07030
%
% Control Systems Engineering Toolbox Version 7.0 
% Copyright  2015 by John Wiley & Sons, Inc.

% TryIt 5.2
% Use the following MATLAB and Control System Toolbox
% statements to find z, wn, %OS, Ts, Tp, and Tr for the 
% closedloop unity feedback system described in 
% Skill-Assessment Exercise 5.2. Start with a -2
% and try some other values. A step response for the 
% closed-loop system will also be produced.

'TryIt 5.2'
a=2;
numg=16;
deng=poly([0 -a]);
G=tf(numg,deng);
T=feedback(G,1);
[numt,dent]=...
tfdata(T,'v');
wn=sqrt(dent(3))
z=dent(2)/(2*wn)
Ts=4/(z*wn)
Tp=pi/(wn*...
sqrt(1-z^2))
pos=exp(-z*pi...
/sqrt(1-z^2))*100
Tr=(1.76*z^3-...
0.417*z^2+1.039*z+1)/wn
step(T)
